#include <iostream>
#include <cstdio>
#include <vector>
#include <cstring>
#include <string>
#include <cmath>
#include <algorithm>
using namespace std;

const int maxn = 50500;
int x[maxn];
int r[maxn];
double sl[maxn];
double lh[maxn];


double sqr(double x)
{
	return x * x;
}

int n;

const int MS = 20;
int getK[maxn];
pair <double, int> mos[MS][maxn];

void setMos(int n)
{
	for (int i = 0; i < n; i++)
		mos[0][i] = make_pair(lh[i], i);
	for (int i = 1; i < MS; i++)
		for (int j = 0; j + (1 << i) <= n; j++)
			mos[i][j] = min(mos[i - 1][j], mos[i - 1][j + (1 << (i - 1) ) ] );
}

void precalc()
{
	int cur = 0;
	for (int i = 1; i < maxn; i++)
	{
		if ( (2 << cur) <= i)
			cur++;
		getK[i] = cur;
	}
}

double minOnSegm(int lid, int rid)
{
	if (rid > lid)
		return -1;
	int k = getK[rid - lid];
//	printf("ld = %d, rid = %d, mos[0][1] = %d\n", lid, rid, mos[0][1].second);
	return min(mos[k][lid], mos[k][rid - (1 << k) + 1] ).first;
}

bool test(int lid, double m)
{
//	printf("m = %.10lf\n", m);
	double lpos = x[lid] - sqrt(sqr(r[lid] ) - sqr(m / 2.) );
	double rpos = lpos + m;
	int rid = lower_bound(sl + 1, sl + n, rpos) - sl - 1;
//	printf("lpos = %.5lf, rpos = %.5lf, rid = %d\n", lpos, rpos, rid);
	if (minOnSegm(lid + 1, rid) < m / 2.)
	{
		return false;
	}
	if (x[rid] + r[rid] < rpos)
	{
		return false;
	}
	if (r[rid] < m / 2.)
	{
		return false;
	}
	double rmax = x[rid] + sqrt(sqr(r[rid] ) - sqr(m / 2.) );
	if (rpos > rmax)
	{
		return false;
	}
	return true;
}


bool solve()
{
	scanf("%d", &n);
	if (n == 0)
		return false;
	for (int i = 0; i < n; i++)
	{
		scanf("%d %d", &x[i], &r[i] );
	}
	for (int i = 1; i < n; i++)
	{
		int d = x[i] - x[i - 1];
//		printf("d = %d\n", d);
		double _x = (sqr(d) + sqr(r[i - 1] ) - sqr(r[i] ) ) / (2. * d);
//		printf("_x = %.5lf\n", x);
		lh[i] = sqrt(sqr(r[i - 1] ) - sqr(_x) );
		sl[i] = x[i] - _x; 
//		printf("lh[%d] = %.5lf, sl[%d] = %.5lf\n", i, lh[i], i, sl[i] );
	}
	setMos(n);
	double answer = 0; 
	for (int i = 0; i < n; i++)
	{
		double lb = (double) r[i] * sqrt(2.);
		double rb = 2. * r[i];

		for (int it = 0; it < 60; it++)
		{
			double m = (lb + rb) / 2.;
			if (test(i, m) )
				lb = m;
			else
				rb = m;
		}
		answer = max(answer, lb);
	}
	printf("%.10lf\n", answer);

	return true;
}


int main()
{
	freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);

	precalc();
	while (solve() ) {}

	return 0;
}
